% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalTree.R
\name{buildTree}
\alias{buildTree}
\title{buildTree}
\usage{
buildTree(theObject)
}
\arguments{
\item{theObject}{an IntervalTree object containing a non-empty dataframe.}
}
\value{
an IntervalTree object, with the root being an recursive list of Intervals.
}
\description{
Method for building a binary interval tree given an IntervalTree object with a defined data slot but an undefined root slot.
This method is a wrapper function of the treeFromInterval function. In the first step, the dataframe in the data slot is
converted into a list of Interval objects. Then, the treeFromInterval function is called to construct an interval tree using
the list as an input, and the root of the resulting interval tree is assigned to the root slot of the IntervalTree object.
This method is called implicitly when an IntervalTree object is initialized with a non-empty dataframe.
}
\examples{
m_ranges <- data.frame(c("A", "B", "C", "D"), c(1,2,3,4), c(5,4,6,10))
I <- new("IntervalTree")
I@data <- m_ranges
m_interval_tree <- buildTree(I)
## buildTree is called implicitly
II <- IntervalTree(data=m_ranges, root=list())
## buildTree is called implicitly
m_interval_tree <- new("IntervalTree", data=m_ranges, root=list())
}
