% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalTree.R
\docType{methods}
\name{insertInterval,IntervalTree,character-method}
\alias{insertInterval,IntervalTree,character-method}
\title{insertInterval}
\usage{
\S4method{insertInterval}{IntervalTree,character}(theObject, anInterval)
}
\arguments{
\item{theObject}{an IntervalTree object}

\item{anInterval}{an interval in the form of (name, start, end).}
}
\value{
an IntervalTree object.
}
\description{
Method for inserting an interval into an IntervalTree object. Given an ordered pair of numbers denoting the
start and end of an interval, the interval is first converted into an Interval object, then the
Interval object is inserted by calling the insert() function.
}
\examples{
m_ranges <- data.frame(c("A", "B", "C", "D"), c(-1.1,2,3,4), c(5,4,6,10))
m_interval_tree <- new("IntervalTree", data=m_ranges, root=list())
m_interval_tree <- insertInterval(m_interval_tree, c("testInterval2", 200, 500))
res <- insertInterval(m_interval_tree, c("a",-25,7))
}
