% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{rp_order_single}
\alias{rp_order_single}
\title{Single-Leg Live Order}
\usage{
rp_order_single(
  accountId,
  ticker,
  symType,
  orderId,
  side = NULL,
  ordType = NULL,
  timeInForce = NULL,
  expirationTime = NULL,
  qty = NULL,
  amt = NULL,
  lmtPrc = NULL,
  stopPrc = NULL,
  openCloseIndicator = NULL
)
}
\arguments{
\item{accountId}{= Public Brokerage Account Number}

\item{ticker}{= Ticker symbol: Ex. "SPY"}

\item{symType}{= Ticker Type: Ex. 'EQUITY','OPTION','MULTI_LEG_INSTRUMENT', 'CRYPTO', 'ALT','TREASURY', 'BOND', 'INDEX'}

\item{orderId}{= The order ID: use rp_getOrderId()}

\item{side}{= The Order Side BUY/SELL. For Options also include the openCloseIndicator. Ex. 'BUY' OR 'SELL'}

\item{ordType}{= The Type of order: Ex. 'MARKET','LIMIT', 'STOP', 'STOP_LIMIT'}

\item{timeInForce}{= The time in for the order: Ex. 'DAY' OR 'GTD"}

\item{expirationTime}{= The expiration date. Only used when timeInForce is GTD, cannot be more than 90 days in the future}

\item{qty}{= The order quantity. Used when buying/selling whole shares and when selling fractional. Mutually exclusive with amount}

\item{amt}{= The order amount. Used when buying/selling shares for a specific notional value}

\item{lmtPrc}{= The limit price. Used when orderType = LIMIT or orderType = STOP_LIMIT}

\item{stopPrc}{= The stop price. Used when orderType = STOP or orderType = STOP_LIMIT}

\item{openCloseIndicator}{= Used for options only. Indicates if this is BUY to OPEN/CLOSE}
}
\value{
Submit a live single-leg order and and returns the order ID as a \code{data.frame}.
}
\description{
Single-Leg Live Order
}
\examples{
\dontrun{
 # Submit a live single-leg order to your Public Brokerage Account
 my_acc <- rp_getAccts() 
 
 # Option Order
 rp_order_singleLeg(accountId = my_acc$accountId, ticker = "SPY250815C00633000", symType = "OPTION", 
                    orderId = rp_getOrderId(), side = "BUY", ordType = "LIMIT", lmtPrc = 1.50, 
                    timeInForce = "DAY", qty = 1, openCloseIndicator = "OPEN")
               
 # Equity Fraction Share Order                   
 rp_preOrder_singleLeg(accountId = my_acc$accountId, ticker = "TSLA", symType = "EQUITY", 
                       side = "BUY", ordType = "MARKET", timeInForce = "DAY", qty = 0.50,
                       openCloseIndicator = "OPEN")
}
}
