% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_plot2.R
\name{bar_plot2}
\alias{bar_plot2}
\title{The second barplot of the ranks of genotypes}
\usage{
bar_plot2(datap, lowt = FALSE, verbose = FALSE)
}
\arguments{
\item{datap}{The data set}

\item{lowt}{A parameter indicating whether lower rates of the trait
is preferred or not. For grain yield e.g. Upper values is preferred. For plant height
lower values e.g. is preferred.}

\item{verbose}{If \code{verbose = TRUE} then some results are printed}
}
\value{
Returns an object of class \verb{gg, graphics}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\itemize{
\item \code{bar_plot2()} creates the 2nd barplot of the ranks of genotypes
using the \code{graphics} package.
}
}
\examples{
# Case 1:  Higher trait values are preferred. For instance grain yield
# in cereals is a trait which its higher values are preferred and ranking
# is performed from the higher to lower values i.e. 1st, 2nd, 3rd etc
# in maize dataset.
\donttest{
data(maize)
bar_plot2(maize) # or: bar_plot2(maize, lowt = FALSE, verbose = FALSE)
}
# Case 2:  In this case, the lower values of the given trait are preferred.
# For instance days to maturity (dm) and plant height are traits where their
# lower values are preferred.
\donttest{
data(dm)
bar_plot2(dm, lowt = TRUE, verbose = TRUE)
}
}
\author{
{
Ali Arminian \href{mailto:abeyran@gmail.com}{abeyran@gmail.com}
}
}
