% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initmetagauss.R
\name{initmetagauss}
\alias{initmetagauss}
\title{Generate the spectral amplitudes for a metagaussian field}
\usage{
initmetagauss(sx, ns)
}
\arguments{
\item{sx}{spectral slope for the output field.
The convention is that this is the slope of \code{k*|A(k)|^2}.}

\item{ns}{size of the output field.}
}
\value{
Output complex field in Fourier space with specified spectral slope,
with dimensions \code{c(ns, ns)}.
}
\description{
A Fourier spectrum with prescribed logarithimic slope and
zero phases is constructed.
}
\examples{
# Make a synthetic rainfall field with prescribed logarithmic spectral slope
f = initmetagauss(1.7, 64)
r = metagauss(f)
# Check slope of the resulting field
fx <- fft2d(r)
fitslope(fx)
# 1.640373
}
\author{
Jost von Hardenberg, \email{j.vonhardenberg@isac.cnr.it}
}
