% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_polygon.R
\name{geo_polygon}
\alias{geo_polygon}
\title{Random GeoJSON polygon}
\usage{
geo_polygon(count = 1, num_vertices = 10, max_radial_length = 10,
  bbox = NULL)
}
\arguments{
\item{count}{(integer/numeric) number of Polygons. Default: 1}

\item{num_vertices}{(integer/numeric) how many coordinates each
polygon will contain. Default: 10}

\item{max_radial_length}{(integer/numeric) maximum distance that a vertex
can reach out of the center of the polygon. Units are in degrees latitude
(Approximately 69 miles or 111 km). Default: 10}

\item{bbox}{(integer/numeric) lat/long bounding box for the centers of the
polygons, numeric vector of the form
\code{west (long), south (lat), east (long), north (lat)}. optional}
}
\value{
GeoJSON; a list with one ore more Polygons in a FeatureCollection,
with class \code{geo_list} - simple \code{unclass()} to remove the class
}
\description{
Random GeoJSON polygon
}
\examples{
geo_polygon()
geo_polygon(10)
geo_polygon(bbox = c(50, 50, 60, 60))
}
