% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blueprint.R
\name{bp_where}
\alias{bp_where}
\title{Blueprint based on a condition}
\usage{
bp_where(condition, bp, ...)
}
\arguments{
\item{condition}{Condition to check before evaluating. Results will be given where
this is \code{TRUE}, and \code{NA} when this is \code{FALSE}}

\item{bp}{Blueprint function to run based on the condition}

\item{...}{arguments passed on to Blueprint, such as \code{.seed}}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Runs a blueprint function where a condition is true, otherwise
returns \code{NA} values
}
\examples{
make_tbl <- blueprint(
  x = r_norm(),
  y = r_unif()
)

set_n(10)
i <- r_lgl()

bp_where(i, make_tbl)

df <- tibble::tibble(
  id = 1:10,
  cnd = r_lgl()
)
dplyr::mutate(df, bp_where(cnd, make_tbl))
}
