% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rel_var}
\alias{rel_var}
\title{Related Variables: Assign}
\usage{
rel_var(df, var_name, related_var, var_values = NULL)
}
\arguments{
\item{df}{(\code{data.frame})\cr Data frame containing the related variables.}

\item{var_name}{(\code{character})\cr Name of variable related to \code{rel_var} to add to \code{df}.}

\item{related_var}{(\code{character})\cr Name of variable within \code{df} with values to which values
of \code{var_name} must relate.}

\item{var_values}{(\code{any})\cr Vector of values related to values of \code{related_var}.}
}
\value{
\code{df} with added factor variable \code{var_name} containing \code{var_values} corresponding to \code{related_var}.
}
\description{
Assign values to a related variable within a domain.
}
\examples{
# Example with data.frame.
params <- c("Level A", "Level B", "Level C")
adlb_df <- data.frame(
  ID = 1:9,
  PARAM = factor(
    rep(c("Level A", "Level B", "Level C"), 3),
    levels = params
  )
)
rel_var(
  df = adlb_df,
  var_name = "PARAMCD",
  var_values = c("A", "B", "C"),
  related_var = "PARAM"
)

# Example with tibble.
adlb_tbl <- tibble::tibble(
  ID = 1:9,
  PARAM = factor(
    rep(c("Level A", "Level B", "Level C"), 3),
    levels = params
  )
)
rel_var(
  df = adlb_tbl,
  var_name = "PARAMCD",
  var_values = c("A", "B", "C"),
  related_var = "PARAM"
)
}
