% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rtpois}
\alias{rtpois}
\title{Zero-Truncated Poisson Distribution}
\usage{
rtpois(n, lambda)
}
\arguments{
\item{n}{(\code{numeric})\cr Number of random numbers.}

\item{lambda}{(\code{numeric})\cr Non-negative mean(s).}
}
\value{
The random numbers.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This generates random numbers from a zero-truncated Poisson distribution,
i.e. from \code{X | X > 0} when \code{X ~ Poisson(lambda)}. The advantage here is that
we guarantee to return exactly \code{n} numbers and without using a loop internally.
This solution was provided in a post by
\href{https://stat.ethz.ch/pipermail/r-help/2005-May/070680.html}{Peter Dalgaard}.
}
\examples{
x <- rpois(1e6, lambda = 5)
x <- x[x > 0]
hist(x)

y <- rtpois(1e6, lambda = 5)
hist(y)
}
