% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_vifs.R
\name{robust_vifs}
\alias{robust_vifs}
\title{Non-linear Variance Inflation Factors}
\usage{
robust_vifs(formula, data, model = randomForest, log10 = TRUE, num_var, ...)
}
\arguments{
\item{formula}{an object of class "\link{formula}" (or one that can be
coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame containing the variables in the model.
By default the variables are taken from the environment which the model
is called from.}

\item{model}{Model to use for extraction partial correlations. Possible
model choices are rpart.}

\item{log10}{Applies a log10 transformation to VIFs when True. Default is
True.}

\item{num_var}{Optional integer argument for reducing the number of
variables to the top 'num_var'. Should be an integer between 1 and the
total number of predictor variables in the model or it should be a
positive proportion of variables desired.}

\item{...}{Additional arguments to be passed to models as needed.}
}
\value{
A list of data.frames and useful plots for user evaluations of
  VIFs.
}
\description{
A list of data.frames and useful plots for user evaluations of
  the randomForest hyperparameter mtry.
}
\examples{
rv <- robust_vifs(Petal.Length ~ ., data = iris[-5], model = lm)
rv
}
