% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapidsplit.R
\name{rapidsplit}
\alias{rapidsplit}
\alias{print.rapidsplit}
\alias{plot.rapidsplit}
\alias{rapidsplit.chunks}
\title{rapidsplit}
\usage{
rapidsplit(
  data,
  subjvar,
  diffvars = NULL,
  stratvars = NULL,
  subscorevar = NULL,
  aggvar,
  splits = 6000,
  aggfunc = c("means", "medians"),
  errorhandling = list(type = c("none", "fixedpenalty"), errorvar = NULL, fixedpenalty =
    600, blockvar = NULL),
  standardize = FALSE,
  include.scores = TRUE,
  verbose = TRUE,
  check = TRUE
)

\method{print}{rapidsplit}(x, ...)

\method{plot}{rapidsplit}(
  x,
  type = c("average", "minimum", "maximum", "random", "all"),
  show.labels = TRUE,
  ...
)

rapidsplit.chunks(
  data,
  subjvar,
  diffvars = NULL,
  stratvars = NULL,
  subscorevar = NULL,
  aggvar,
  splits = 6000,
  aggfunc = c("means", "medians"),
  errorhandling = list(type = c("none", "fixedpenalty"), errorvar = NULL, fixedpenalty =
    600, blockvar = NULL),
  standardize = FALSE,
  include.scores = TRUE,
  verbose = TRUE,
  check = TRUE,
  split.chunksize = 10000,
  sample.chunksize = 200
)
}
\arguments{
\item{data}{Dataset, a \code{data.frame}.}

\item{subjvar}{Subject ID variable name, a \code{character}.}

\item{diffvars}{Names of variables that determine which conditions
need to be subtracted from each other, \code{character}.}

\item{stratvars}{Additional variables that the splits should
be stratified by; a \code{character}.}

\item{subscorevar}{A \code{character} variable identifying subgroups within
a participant's data from which separate scores should be computed.
To compute a participant's final score, these subscores will be averaged together.
A typical use case is the D-score of the implicit association task.}

\item{aggvar}{Name of variable whose values to aggregate, a \code{character}.
Examples include reaction times and error rates.}

\item{splits}{Number of split-halves to average, an \code{integer}.
It is recommended to use around 5000.}

\item{aggfunc}{The function by which to aggregate the variable
defined in \code{aggvar}; can be \code{"means"}, \code{"medians"},
or a custom function (not a function name).
This custom function must take a numeric vector and output a single value.}

\item{errorhandling}{A list with 4 named items, to be used to replace error trials
with the block mean of correct responses plus a fixed penalty, as in the IAT D-score.
The 4 items are \code{type} which can be set to \code{"none"} for no error replacement,
or \code{"fixedpenalty"} to replace error trials as described;
\code{errorvar} requires name of the \code{logical} variable indicating an incorrect response
(as \code{TRUE}); \code{fixedpenalty} indicates how much of a penalty should be added
to said block mean; and \code{blockvar} indicates the name of the block variable.}

\item{standardize}{Whether to divide by scores by the subject's SD; a \code{logical}.
Regardless of whether error penalization is utilized, this standardization
will be based on the unpenalized SD of correct and incorrect trials, as in the IAT D-score.}

\item{include.scores}{Include all individual split-half scores?}

\item{verbose}{Display progress bars? Defaults to \code{TRUE}.}

\item{check}{Check input for possible problems?}

\item{x}{\code{rapidsplit} object to print or plot.}

\item{...}{Ignored.}

\item{type}{Character argument indicating what should be plotted. 
By default, this plots the random split whose correlation is closest to the average.
However, this can also plot the random split with 
the \code{"minimum"} or \code{"maximum"} split-half correlation, or any \code{"random"} split. 
\code{"all"} splits can also be plotted together in one figure.}

\item{show.labels}{Should participant IDs be shown above their points in the scatterplot?
Defaults to \code{TRUE} and is ignored when \code{type} is \code{"all"}.}

\item{split.chunksize, sample.chunksize}{Number of chunks to divide the splits and sample in 
for more memory-efficient computation. This has no bearing on the result.}
}
\value{
A \code{list} containing
\itemize{
\item \code{r}: the averaged reliability.
\item \code{ci}: the 95\% confidence intervals.
\item \code{allcors}: a vector with the reliability of each iteration.
\item \code{nobs}: the number of participants.
\item \code{rcomponents}: a list containing the mean variance of the scores of both halves,
as well as their mean covariance.
\item \code{scores}: the individual participants scores in each split-half,
contained in a list with two matrices (Only included if requested with \code{include.scores}).
}
}
\description{
A very fast algorithm for computing stratified permutation-based split-half reliability.
}
\details{
The order of operations (with optional steps between brackets) is:
\itemize{
\item Splitting
\item (Replacing error trials within block within split)
\item Computing aggregates per condition (per subscore) per person
\item Subtracting conditions from each other
\item (Dividing the resulting (sub)score by the SD of the data used to compute that (sub)score)
\item (Averaging subscores together into a single score per person)
\item Computing the covariances of scores from one half with scores from the other half
for every split
\item Computing the variances of scores within each half for every split
\item Computing the average split-half correlation with the average variances and covariance
across all splits, using \code{\link[=corStatsByColumns]{corStatsByColumns()}}
\item Applying the Spearman-Brown formula to the absolute correlation
using \code{\link[=spearmanBrown]{spearmanBrown()}}, and restoring the original sign after
}

\code{\link[=cormean]{cormean()}} was used to aggregate correlations in previous versions
of this package & in the associated manuscript, but the method based on
(co)variance averaging was found to be more accurate. This was suggested by
prof. John Christie of Dalhousie University.
}
\note{
\itemize{
\item \code{\link[=rapidsplit]{rapidsplit()}} function can use a lot of memory in one go.
If you are computing the reliability of a large dataset or you have little RAM,
it may pay off to use \code{\link[=rapidsplit.chunks]{rapidsplit.chunks()}} instead.
\item It is currently unclear it is better to pre-process your data before or after splitting it.
If you are computing the IAT D-score,
you can therefore use \code{errorhandling} and \code{standardize} to perform these two actions
after splitting, or you can process your data before splitting and forgo these two options.
}
}
\examples{

data(foodAAT)
# Reliability of the double difference score:
# [RT(push food)-RT(pull food)] - [RT(push object)-RT(pull object)]

frel<-rapidsplit(data=foodAAT,
                 subjvar="subjectid",
                 diffvars=c("is_pull","is_target"),
                 stratvars="stimid",
                 aggvar="RT",
                 splits=100)
                 
print(frel)

plot(frel,type="average")

           
# Compute a single random split-half reliability of the error rate
rapidsplit(data=foodAAT,
           subjvar="subjectid",
           aggvar="error",
           splits=1,
           aggfunc="means")

# Compute the reliability of an IAT D-score
data(raceIAT)
rapidsplit(data=raceIAT,
           subjvar="session_id",
           diffvars="congruent",
           subscorevar="blocktype",
           aggvar="latency",
           errorhandling=list(type="fixedpenalty",errorvar="error",
                              fixedpenalty=600,blockvar="block_number"),
           splits=10,
           standardize=TRUE)


# Compute the reliability of mean RT
# in subsets of 200 splits and 100 participants per run
rapidsplit.chunks(data=foodAAT,
                  subjvar="subjectid",
                  aggvar="RT",
                  splits=400,
                  split.chunksize=200,
                  sample.chunksize=50)

}
\references{
Kahveci, S., Bathke, A.C. & Blechert, J. (2024)
Reaction-time task reliability is more accurately computed with
permutation-based split-half correlations than with Cronbach’s alpha.
Psychonomic Bulletin and Review. \doi{10.3758/s13423-024-02597-y}
}
\author{
Sercan Kahveci
}
