% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_mean_size.R
\name{k_mean_size}
\alias{k_mean_size}
\title{Sample Size or Power Calculation for K Means}
\usage{
k_mean_size(
  muA,
  muB,
  kappa = 1,
  sd = NULL,
  sdA = NULL,
  sdB = NULL,
  tau = 1,
  alpha,
  beta = NULL,
  n = NULL,
  nA = NULL,
  test_type = "2-side"
)
}
\arguments{
\item{muA}{Numeric. True mean of group A.}

\item{muB}{Numeric. True mean of group B.}

\item{kappa}{Numeric. Ratio of sample sizes (nA/nB). Default is 1.}

\item{sd}{Numeric (optional). Standard deviation. Required for \code{"2-side"} test.}

\item{sdA}{Numeric (optional). Standard deviation of group A. Required for \code{"1-side"} test.}

\item{sdB}{Numeric (optional). Standard deviation of group B. Required for \code{"1-side"} test.}

\item{tau}{Integer. Number of comparisons.}

\item{alpha}{Numeric. Type I error rate.}

\item{beta}{Numeric (optional). Type II error rate (1 - power). Required for sample size calculation.}

\item{n}{Integer (optional). Sample size. Required for power calculation of \code{"2-side"} test.}

\item{nA}{Integer (optional). Sample size of group A. Required for power calculation of \code{"1-side"} test.}

\item{test_type}{Character. \code{"2-side"} or \code{"1-side"}. Default is \code{"2-side"}}
}
\value{
Numeric. Returns sample size (if \code{beta} is given), or power (if \code{n}/\code{nA} is given).
}
\description{
Calculates sample size or power for a multiple-sample mean test.
}
\note{
Only one of \code{beta} (for sample size calculation) or \code{n}/\code{nA} (for power calculation) should be specified.

Required arguments by \code{test_type}:
\itemize{
\item \code{"2-side"}:
\itemize{
\item For sample size: \code{muA}, \code{muB}, \code{sd}, \code{tau}, \code{alpha}, \code{beta}
\item For power: \code{muA}, \code{muB}, \code{sd}, \code{tau}, \code{alpha}, \code{n}
}
}

-\code{"1-side"}:
\itemize{
\item For sample size: \code{muA}, \code{muB}, \code{sdA}, \code{sdB}, \code{tau}, \code{alpha}, \code{beta}
\item For power: \code{muA}, \code{muB}, \code{sdA}, \code{sdB}, \code{tau}, \code{alpha}, \code{nA}
}
}
\examples{
# Sample size for `"2-side"` test
k_mean_size(muA = 5, muB = 10, sd = 10, tau = 1,
            alpha = 0.05, beta = 0.2, test_type = "2-side")

# Power of `"2-side"` test
k_mean_size(muA = 5, muB = 10, sd = 10, tau = 1,
            alpha = 0.05, n = 63, test_type = "2-side")

# Sample size for `"1-side"` test
k_mean_size(muA = 132.86, muB = 127.44, kappa = 2, sdA = 15.34, sdB = 18.23, tau = 1,
            alpha = 0.05, beta = 0.2, test_type = "1-side")

# Power of `"1-side"` test
k_mean_size(muA = 132.86, muB = 127.44, kappa = 2, sdA = 15.34, sdB = 18.23, tau = 1,
            alpha = 0.05, nA = 85, test_type = "1-side")

}
