% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterLocalSums.R
\name{rasterLocalSums}
\alias{rasterLocalSums}
\title{Local sums for an in memory raster image.}
\usage{
rasterLocalSums(r, W)
}
\arguments{
\item{r}{An in memory raster image.}

\item{W}{A matrix of weights.  The sums will be applied at each centroid. 
Dimensions must be non-zero and odd.  Only non-missing neighbors are used in 
the sum.}
}
\value{
An in memory raster image of local sums.
}
\description{
\code{rasterLocalSums} finds the local sum within the weighted neighborhood of W.
}
\details{
A spatial neighborhood is calculated for each pixel in \code{r}.
  The spatial neighborhood for each pixel is defined by the weight matrix
  \code{W}, where the center of the odd dimensioned matrix \code{W} is identified 
  with the target pixel.  The target pixel value is replaced with the sum of
  all pixels within the neighborhood weighted by \code{W}.   Only non-missing 
  or neighbors with non-zero weights are used in the calculation.
}
\examples{
r <- raster::raster( matrix(rnorm(36),6,6)) 
W <- matrix(1,3,3)
sumR <- rasterLocalSums(r,W)
}
