% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_dawid_skene_model}
\alias{simulate_dawid_skene_model}
\title{Simulate data from the Dawid-Skene model}
\usage{
simulate_dawid_skene_model(pi, theta, sim_data, seed = NULL)
}
\arguments{
\item{pi}{The pi parameter of the Dawid-Skene model.}

\item{theta}{The theta parameter of the Dawid-Skene model.}

\item{sim_data}{Data to guide the simulation. The data must be in the long
data format used in \code{rater()} except without the 'rating' column. The data
specifies:
\itemize{
\item the number of items in the data, and
\item which raters rate each item and how many times they do so.
}}

\item{seed}{An optional random seed to use.}
}
\value{
The passed \code{sim_data} augmented with columns:
\itemize{
\item \code{"z"} containing the latent class of each item,
\item \code{"rating"} containing the simulated ratings.
}
}
\description{
Simulate data from the Dawid-Skene model
}
\details{
The number of raters implied by the entries in the rater column
must match the number of raters implied by the passed theta parameter.

This function can also be used to simulate from the class-conditional
Dawid-Skene model by specifying theta in the required form (i.e where
all off-diagonal entries of the error matrices are equal.)
}
\examples{

\donttest{

J <- 5
K <- 4
pi <- rep(1 / K, K)
theta <- make_theta(0.7, J, K)
sim_data <- data.frame(item = rep(1:2, each = 5), rater = rep(1:5, 2))

simulations <- simulate_dawid_skene_model(pi, theta, sim_data)
simulations

}

}
