% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pdb.R
\name{read_pdb}
\alias{read_pdb}
\title{Read PDB File}
\usage{
read_pdb(filename, atom = TRUE, nsr = TRUE)
}
\arguments{
\item{filename}{Path to the PDB file.}

\item{atom}{Default `TRUE`. Whether to pull out standard residue (ATOM) records.}

\item{nsr}{Default `TRUE`. Whether to pull out nonstandard residue (HETAHM) records.}
}
\value{
List giving the atom locations.
}
\description{
Reads an PDB file and extracts the atom locations and bonds (does not include any other structual
information currently). This pulls out ATOM and HETAHM records by default, along with available
connections.
}
\examples{
#This assumes a hypothetical PDB file in your working directory:
if(file.exists("3nir.pdb")) {
  read_pdb("3nir.pdb") \%>\%
    generate_full_scene() \%>\%
    render_model()
}
}
