% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_ellipsoid}
\alias{csg_ellipsoid}
\title{CSG Ellipsoid}
\usage{
csg_ellipsoid(x = 0, y = 0, z = 0, axes = c(0.5, 1, 0.5))
}
\arguments{
\item{x}{Default `0`. x-coordinate on the ellipsoid.}

\item{y}{Default `0`. y-coordinate on the ellipsoid.}

\item{z}{Default `0`. z-coordinate on the ellipsoid.}

\item{axes}{Default `c(0.5,1,0.5)`. Ellipsoid principle axes.}
}
\value{
List describing the ellipsoid in the scene.
}
\description{
CSG Ellipsoid
}
\examples{
if(run_documentation()) {
#Generate a basic ellipsoid:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_ellipsoid(),material=glossy(color="red"))) \%>\% 
  render_scene(clamp_value=10, samples=16,fov=20)
  }
if(run_documentation()) {
#Three different ellipsoids:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
 add_object(csg_object(csg_group(list(
   csg_ellipsoid(x=-1.2, axes = c(0.2,0.5,0.5)),
   csg_ellipsoid(x=0, axes = c(0.5,0.2,0.5)),
   csg_ellipsoid(x=1.2, axes = c(0.5,0.5,0.2)))),
   material=glossy(color="red"))) \%>\% 
 render_scene(clamp_value=10, samples=16,fov=20,lookfrom=c(0,5,10))
 }
if(run_documentation()) {
#Generate a glass ellipsoid:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_ellipsoid(),material=dielectric(attenuation = c(1,1,0.3)))) \%>\% 
  render_scene(clamp_value=10, samples=16,fov=20)
  }
if(run_documentation()) {
#Generate a glass ellipsoid in a Cornell box:
generate_cornell() \%>\% 
  add_object(csg_object(csg_ellipsoid(x=555/2,y=555/2,z=555/2,axes=c(100,150,200)),
    material=dielectric(attenuation = c(1,0.3,1)/200))) \%>\% 
  render_scene(clamp_value=10, samples=16)
}
}
