% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_multipolygonz_to_obj.R
\name{save_multipolygonz_to_obj}
\alias{save_multipolygonz_to_obj}
\title{Save MULTIPOLYGON Z sf data to OBJ file}
\usage{
save_multipolygonz_to_obj(sfobj, filename, swap_yz = FALSE)
}
\arguments{
\item{sfobj}{sf object with MULTIPOLYGON Z geometry,}

\item{filename}{Filename of the OBJ to save the 3D model to.}

\item{swap_yz}{Default `TRUE`., Whether to swap and Y and Z axes. (Y axis is vertical in 
rayshader coordinates, but data is often provided with Z being vertical).}
}
\description{
Converts MULTIPOLYGON Z features into a 3D OBJ model
}
\examples{
#Convert the built-in Washington Monument MULTIPOLYGON Z data to an OBJ file
obj_temp = tempfile(fileext=".obk")
save_multipolygonz_to_obj(washington_monument_multipolygonz, obj_temp, swap_yz=TRUE)
#Render with rgl
rgl::open3d()
render_obj(filename=obj_temp, xyz=matrix(c(0,0,0),ncol=3), color="red")
render_camera(theta=30,phi=40)
}
