% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{save_data}
\alias{save_data}
\title{Save Fetched Data to Multiple Formats}
\usage{
save_data(df, filename = NULL, format = "rds")
}
\arguments{
\item{df}{Data frame to save (with fetch_info attribute for auto-naming).}

\item{filename}{\strong{Required}. A non-empty string (without extension) must be provided.}

\item{format}{Output format: "rds", "csv", or "xlsx". Default "rds".}
}
\value{
Full file path (invisibly).
}
\description{
Save Fetched Data to Multiple Formats
}
\examples{
\donttest{
  my_data <- fetch_bddk1(2024, 1, 15)
  temp_file <- tempfile() # filename should be without extension
  save_data(my_data, temp_file, format = "csv")
}
}
