% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbtt.R
\name{rbtt}
\alias{rbtt}
\title{Perform robust bootstrapped t-tests}
\usage{
rbtt(x, y, n.boot, n.cores = 1, method = "combined", conf.level = 0.95)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{a (non-empty) numeric vector of data values.}

\item{n.boot}{number of bootstrap resamples to perform}

\item{n.cores}{number of cores to use for parallelization. Defaults to 1. If using Windows, set n.cores = 1.}

\item{method}{Which robust bootstrapped t-test to perform. Set `method=1’ for a two-sample t-test under the equal variance assumption, 'method = 2' for a two-sample t-test without the equal variance assumption, and 'method = "both"' to perform both methods simultaneously.}

\item{conf.level}{Desired confidence level for computing confidence intervals: a number between 0 and 1.}
}
\value{
A list (or two lists in the case of method = "combined") containing the following components:\cr
\item{statistic}{the value of the t-statistic.}
\item{p.value}{the p-value for the test.}
\item{conf.int}{a bootstrap-based confidence interval for the difference in means.}
\item{estimate}{the estimated difference in means.}
\item{null.value}{the hypothesized value of the mean difference, zero.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string describing the type of two-sample bootstrapped t-test used}
\item{data.name}{a character string giving the names of the data}
}
\description{
Perform robust bootstrapped two-sample t-tests that aim to better control type-I error rates
when comparing means of non-negative distributions with excess zero observations.
}
\examples{
x=rbinom(50,1,0.5)*rlnorm(50,0,1)
y=rbinom(150,1,0.3)*rlnorm(150,2,1)

rbtt(x, y, n.boot=999)

# Perform bootstrap resamples on 2 cores
rbtt(x, y, n.boot=999, n.cores=2)

# Use methods 1 or 2 individually
rbtt(x, y, n.boot = 999, method = 1)
rbtt(x, y, n.boot = 999, method = 2)

# Use a confidence level of 0.99
rbtt(x, y, n.boot = 999, conf.level = 0.99)
}
