% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenith_image.R
\name{zenith_image}
\alias{zenith_image}
\title{Build Zenith image}
\usage{
zenith_image(diameter, lens_coef)
}
\arguments{
\item{diameter}{numeric vector of length one. Diameter in pixels expressed as
an even integer. This places the zenith point between pixels. Snapping the
zenith point between pixels does not affect accuracy because half-pixel
is less than the uncertainty in localizing the circle within the
picture.}

\item{lens_coef}{numeric vector. Polynomial coefficients of the lens
projection function. See \code{\link[=lens]{lens()}}.}
}
\value{
\link[terra:SpatRaster-class]{terra::SpatRaster} with zenith angles in
degrees, showing a complete hemispherical view with the zenith at the
center. The object carries attributes \code{lens_coef}.
}
\description{
Build a single-layer image with zenith angle values, assuming upwards-looking
hemispherical photography with the optical axis vertically aligned.
}
\examples{
z <- zenith_image(600, lens("Nikon_FCE9"))
plot(z)
}
