% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spp_eu_legislation.R
\name{spp_eu_legislation}
\alias{spp_eu_legislation}
\title{Get current EU annex listings, SRG opinions, and EU suspensions}
\usage{
spp_eu_legislation(
  taxon_id,
  scope = "current",
  language = "en",
  raw = FALSE,
  token = NULL,
  verbose = TRUE,
  pause = 1,
  ...
)
}
\arguments{
\item{taxon_id}{a vector of character strings containing species' taxon
concept identifiers (see \code{\link[=spp_taxonconcept]{spp_taxonconcept()}}).}

\item{scope}{vector of character strings indicating the time scope of
legislation, values are taken among \code{current}, \code{historic} and \code{all}.
Default is set to \code{current}.}

\item{language}{vector of character strings indicating the language for the
text of legislation notes, values are taken among \code{en} (English),
\code{fr} (French) and \code{es} (Spanish). Default is \code{en}.}

\item{raw}{a logical. Should raw data be returned?}

\item{token}{a character string containing the authentification token, see
\url{https://api.speciesplus.net/documentation}. Default is set to
\code{NULL} and requires the environment variable \code{SPECIESPLUS_TOKEN} to be
set directly in \code{Renviron}. Alternatively, \code{\link[=set_token]{set_token()}} can
be used to set \code{SPECIESPLUS_TOKEN} for the current session.}

\item{verbose}{a logical. Should extra information be reported on progress?}

\item{pause}{a duration (in second) to suspend execution for (see
\code{\link[=Sys.sleep]{Sys.sleep()}}). This was added cause the web API returns a 404 error too many
requests in a short time interval.}

\item{...}{Further named parameters, see \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
If \code{raw} is set to \code{TRUE} then an object of class \code{spp_raw} (or
\code{spp_raw_multi} if \code{length(taxon_id)>1}) is returned which is essentially
a list of lists (see option \code{as = 'parsed'} in \code{\link[httr:content]{httr::content()}}).
Otherwise, an object of class \code{spp_eu_leg} (or \code{spp_eu_leg_multi} if
\code{length(taxon_id)>1}) is returned which is a list of two data frames:
\enumerate{
\item \code{eu_listings}: lists EU annex listings EU suspensions,
\item \code{eu_decisions}: lists EU decisions
}
}
\description{
Retrieve current EU annex listings, SRG opinions, and EU suspensions for a
given taxon concept (identifier must be known).
}
\examples{
\dontrun{
# this calls will only work if a token is set and valid
res1 <- spp_eu_legislation(taxon_id = '4521')
res2 <- spp_eu_legislation(taxon_id = c('4521', '3210', '10255'))
res3 <- spp_eu_legislation(taxon_id = '4521', scope = 'historic')
res4 <- spp_eu_legislation(taxon_id = '4521', scope = 'all', language='fr',
 verbose = FALSE, config=httr::verbose())
}
}
\references{
\url{https://api.speciesplus.net/documentation/v1/eu_legislation/index.html}
}
