% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge_configs}
\alias{merge_configs}
\title{Merge Configurations}
\usage{
merge_configs(base_cfg, override_cfg)
}
\arguments{
\item{base_cfg}{A list containing the base configuration.}

\item{override_cfg}{A list containing override values.}
}
\value{
A merged configuration list.
}
\description{
Recursively merges two configuration lists, with values in the override
replacing those in the base configuration.
}
\examples{

base_cfg <- get_config(system.file("extdata",
"config.yml",package = "rconf"), config_name = "default")
dev_cfg <- get_config(system.file("extdata",
"config.yml", package = "rconf"), config_name = "development")
combined_cfg <- merge_configs(base_cfg, dev_cfg)
print(combined_cfg)

}
