% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{loanDefaultPrediction}
\alias{loanDefaultPrediction}
\title{loanDefaultPrediction}
\usage{
loanDefaultPrediction(loanDataFeatures, loanDataTargets, pct = 0.25)
}
\arguments{
\item{loanDataFeatures}{A matrix of dimension 3 by N, i.e. transposed relative to
what R uses, with the three explanantory variables}

\item{loanDataTargets}{A vector of (integer-valued) binary variables loan repayment
or default}

\item{pct}{A numeric variable with the percentage of data to be used for testing,
defaults to 25\%}
}
\value{
A list object with predictions, probabilities, accuracy and a report matrix
}
\description{
Predict loan default using a decision tree model
}
\details{
This functions performs a loan default prediction based on three variables
on employment, bank balance and annual salary to predict loan repayment or
default
}
\examples{
data(loanData)
res <- loanDefaultPrediction(t(as.matrix(loanData[,-4])),  # col 1 to 3, transposed
                             loanData[, 4],                # col 4 is the target
                             0.25)                         # retain 25\% for testing
str(res)
res$report
}
