% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ddi_qstn}
\alias{ddi_qstn}
\alias{ddi_backward}
\alias{ddi_forward}
\alias{ddi_ivuInstr}
\alias{ddi_postQTxt}
\alias{ddi_preQTxt}
\alias{ddi_qstnLit}
\title{qstn and its child nodes}
\usage{
ddi_qstn(...)

ddi_backward(...)

ddi_forward(...)

ddi_ivuInstr(...)

ddi_postQTxt(...)

ddi_preQTxt(...)

ddi_qstnLit(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
\itemize{
\item \code{ddi_qstn()} is the question asked. The element may have mixed content. The
element itself may contain text for the question, with the subelements being
used to provide further information about the question. Alternatively, the
question element may be empty and only the subelements used. The element has
a unique question ID attribute which can be used to link a variable with
other variables where the same question has been asked. This would allow
searching for all variables that share the same question ID, perhaps because
the questions was asked several times in a panel design.
}
}
\details{
#' \emph{Parent nodes}

\code{qstn} is contained in \code{var}.

\emph{qstn specific child nodes}
\itemize{
\item \code{ddi_backward()} contains a reference to IDs of possible preceding questions.
The "qstn" IDREFS may be used to specify the question IDs.
\item \code{ddi_forward()} contains a reference to IDs of possible following questions.
The "qstn" IDREFS may be used to specify the question IDs.
\item \code{ddi_ivuInstr()} are specific instructions to the individual conducting an
interview.
\item \code{ddi_postQTxt()} is the text describing what occurs after the literal question
has been asked.
\item \code{ddi_preQTxt()} is the pre-question text. This is the text describing a set
of conditions under which a question might be asked.
\item \code{ddi_qstnLit()} is the text of the actual, literal question asked.
}
}
\examples{
ddi_qstn("When you get together with your friends, would you say you discuss 
political matters frequently, occasionally, or never", ID = "Q125")

# Functions that need to be wrapped in ddi_qstn()

# Including ddi_preQTxt within a ddi_qstn with content
ddi_qstn("When you get together with your friends, would you say you discuss 
political matters frequently, occasionally, or never", ID = "Q125",
         ddi_preQTxt("For those who did not go away on a holiday of four days or more in 1985..."))

ddi_qstn(ddi_postQTxt("The next set of questions will ask about your financial situation")) 

# Using IDREFS in ddi_backward() and ddi_forward()

ddi_backward(qstn = "Q143")

ddi_forward("If yes, please ask questions 120-124", qstn = "Q120 Q121 Q122 Q123 Q124")

# Other child elements

ddi_ivuInstr("Please prompt the respondent if they are reticent to answer this question.", 
              lang = "en")

ddi_qstnLit("Why didn't you go away in 1985?")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/qstn.html}{qstn documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/backward.html}{backward documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/forward.html}{forward documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/ivuInstr.html}{ivuInstr documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/postQTxt.html}{postQTxt documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/preQTxt.html}{preQTxt documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/qstnLit.html}{qstnLit documentation}
}
