% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readit.R
\name{readit}
\alias{readit}
\title{Read Files of Any Type}
\usage{
readit(.data, ..., tidyverse = TRUE)
}
\arguments{
\item{.data}{File path to read data from.}

\item{...}{Additional arguments passed to tidyverse read functions, e.g.
\code{sheet}, \code{n_max}, etc.}

\item{tidyverse}{Should \code{readit} use functions available in the tidyverse,
e.g. functions from \code{readr}, etc.? Defaults to \code{TRUE}.}
}
\description{
Given a file path, read the data into R, regardless of file type/extension.
\code{readit} is a thick wrapper around many of the
\href{https://www.tidyverse.org/}{tidyverse} libraries, but can be forced to use
base functions where possible. Note that the caveat is that the file
\emph{\strong{needs}} to have an extension, as well as be of a relatively common type.
"Common types" are any file type that can be handled by the
\href{https://cran.r-project.org/package=readr}{readr}, \href{https://cran.r-project.org/package=readxl}{readxl},
or \href{https://cran.r-project.org/package=haven}{haven} packages.
}
\examples{
readit(system.file("examples", "csv.csv", package = "readit"))
readit(system.file("examples", "tab_sep.txt", package = "readit"))
readit(system.file("examples", "semi_sep.txt", package = "readit"))
readit(system.file("examples", "xlsx.xlsx", package = "readit"))
readit(system.file("examples", "xls.xls", package = "readit"))
readit(system.file("examples", "iris.sas7bdat", package = "readit"))

}
