% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_timeseries.R
\name{estimate_timeseries}
\alias{estimate_timeseries}
\title{Compute timeseries with uncertainty from bootstrap regression}
\usage{
estimate_timeseries(Surrogate, Regression)
}
\arguments{
\item{Surrogate}{data frame with time (PosixCt) and surrogate(s) (x,...)}

\item{Regression}{data frame from bootstrap_regression() that determines analyte(surrogate)}
}
\value{
list with inputs and uncertainty on timeseries estimated from Regression
}
\description{
Compute uncertainty on timeseries from bootstrap regression after Rustomji and Wilkinson (2008)
}
\examples{
\donttest{
Turbidity_FNU <- realTimeloads::ExampleData$Sonde$Turbidity
TSS_mg_per_l <- realTimeloads::ExampleData$Sediment_Samples$SSCpt_mg_per_liter
Calibration <- data.frame(Turbidity_FNU,TSS_mg_per_l)
time <- realTimeloads::ExampleData$Sonde$time
Surrogate <- data.frame(time,Turbidity_FNU)
Regression = bootstrap_regression(Calibration,'TSS_mg_per_l~Turbidity_FNU')
Output <- estimate_timeseries(Surrogate,Regression)
}
}
\references{
Rustomji, P., & Wilkinson, S. N. (2008). Applying bootstrap resampling to quantify uncertainty in fluvial suspended sediment loads estimated using rating curves. Water resources research, 44(9).https://doi.org/10.1029/2007WR006088

Helsel, D.R., Hirsch, R.M., Ryberg, K.R., Archfield, S.A., and Gilroy, E.J., 2020, #' Statistical methods in water resources: U.S. Geological Survey Techniques and Methods, book 4, chap. A3, 458 p. https://doi.org/10.3133/tm4a3
}
\author{
Daniel Livsey (2023) ORCID: 0000-0002-2028-6128
}
