% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R, R/misc.R
\docType{data}
\name{Anchors}
\alias{Anchors}
\alias{START}
\alias{END}
\alias{exactly}
\title{The start or end of a string.}
\format{An object of class \code{regex} (inherits from \code{character}) of length 1.}
\usage{
START

END

exactly(x)
}
\arguments{
\item{x}{A character vector.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
\code{START} matches the start of a string.
\code{END} matches the end of a string.
\code{exactly} makes the regular expression match the whole string, from
start to end.
}
\note{
Caret and dollar are used as start/end delimiters, since \code{\\A} and
\code{\\Z} are not supported by R's internal PRCE engine or \code{stringi}'s
ICU engine.
}
\examples{
START
END

# Usage
x <- c("catfish", "tomcat", "cat")
(rx_start <- START \%R\% "cat")
(rx_end <- "cat" \%R\% END)
(rx_exact <- exactly("cat"))
stringi::stri_detect_regex(x, rx_start)
stringi::stri_detect_regex(x, rx_end)
stringi::stri_detect_regex(x, rx_exact)
}
\references{
\url{http://www.regular-expressions.info/anchors.html} and
\url{http://www.rexegg.com/regex-anchors.html}
}
\seealso{
\code{\link{whole_word}} and \code{\link{modify_mode}}
}
\keyword{datasets}
