% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n2.R
\name{n2RR}
\alias{n2RR}
\title{Mark-Recapture Sample Size, Robson-Regier}
\usage{
n2RR(
  N,
  n1,
  conf = c(0.99, 0.95, 0.9, 0.85, 0.8, 0.75),
  acc = c(0.5, 0.25, 0.2, 0.15, 0.1, 0.05, 0.01)
)
}
\arguments{
\item{N}{The best guess at true abundance}

\item{n1}{The size of the first (or second) sampling event}

\item{conf}{A vector of the desired levels of confidence to investigate.
Allowed values are any of \code{c(0.99,0.95,0.9,0.85,0.8,0.75)}.  Defaults to
all of \code{c(0.99,0.95,0.85,0.8,0.75)}.}

\item{acc}{A vector of the desired levels of relative accuracy to
investigate.  Allowed values are any of
\code{c(0.5,0.25,0.2,0.15,0.1,0.05,0.01)}.  Defaults to all of
\code{c(0.5,0.25,0.2,0.15,0.1,0.05,0.01)}.}
}
\value{
A list of minimum sample sizes.  Each list element corresponds to a
  unique level of confidence, and is defined as a data frame with each row
  corresponding to a unique value of relative accuracy.  Two minimum sample
  sizes are given: one calculated from the sample size provided for the other
  event, and the other calculated under n1=n2, the most efficient scenario.
}
\description{
Calculates minimum sample size for one sampling event in a
  Petersen mark-recapture experiment, given the sample size in the other
  event and an best guess at true abundance.
}
\note{
Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }

It is possible that the sample size - accuracy relationship will be better illustrated using \link{plotn2sim}.
}
\examples{
n2RR(N=1000, n1=100)
}
\references{
Robson, D. S., and H. A. Regier.  1964.  Sample size in Petersen
  mark-recapture experiments.  Transactions of the American FisheriesSociety
  93:215-226.
}
\seealso{
\link{plotn2sim}, \link{plotn1n2simmatrix}
}
\author{
Matt Tyers
}
