% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n2.R
\name{plotn1n2simmatrix}
\alias{plotn1n2simmatrix}
\title{Mark-Recapture Sample Size Via Sim, Both Samples}
\usage{
plotn1n2simmatrix(
  N,
  conf = 0.95,
  nrange = NULL,
  nstep = NULL,
  estimator = "Chapman",
  nsim = 10000,
  ...
)
}
\arguments{
\item{N}{The best guess at true abundance}

\item{conf}{The desired level of confidence to investigate.
Defaults to 0.95.}

\item{nrange}{A two-element vector describing the range of sample sizes to
investigate.  If the default (\code{NULL}) is accepted, an appropriate
value will be chosen.}

\item{nstep}{The step size between sample sizes to investigate.  If the
default (\code{NULL}) is accepted, an appropriate value will be chosen.}

\item{estimator}{The abundance estimator to use.  Allowed values are
\code{"Chapman"}, \code{"Petersen"}, and \code{"Bailey"}. Defaults to
\code{"Chapman"}.}

\item{nsim}{The number of replicates.  Defaults to 10000.}

\item{...}{Additional plotting parameters}
}
\description{
Produces a plot of the simulated relative accuracy of a
  mark-recapture abundance estimator for various sample sizes in both events.  This may be a
  useful exploration, but it is possible that \link{plotn2sim} may be more informative.
}
\note{
Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }
}
\examples{
plotn1n2simmatrix(N=10000, nsim=2000)
}
\seealso{
\link{n2RR}, \link{plotn2sim}
}
\author{
Matt Tyers
}
