#' Profesorii din afara cuplajelor, cărora le-au rămas distribuții neomogene
#'
#' Exluzând (după apelul funcției interne 'set_prof1_tw1()') profesorii
#'  angajați în cuplaje și toate cuplajele din care fac parte, găsim
#'  pe cei din afara cuplajelor și dintre aceștia, selectăm pe cei
#'  care au mai mult de 'at_least' ore, distribuite cvasi-omogen pe zile.
#' 
#' @param DZ Distribuția curentă a lecțiilor, pe zile
#' @param at_least Vizează numai distribuțiile individuale care au în total,
#'     peste un anumit număr de ore (implicit 8)
#' @return Setul distribuțiilor neomogene (cvasi-omogene)
#' @export

prof_bad_dis <- function(DZ, at_least = 8) {
    tpz <- table(DZ[c('prof', 'zl')])
    NU <- apply(tpz, 1, function(H) 
        if(sum(H) > at_least & diff(range(H)) >= 2) H)
    NU <- NU %>% compact() %>% list2DF()
    if(is.null(cache_env$prof1))
        set_prof1_tw1(DZ)
    twins <- names(cache_env$tw1)
    Prof <- setdiff(names(NU), twins) # care au numai ore proprii
    NU %>% select(all_of(Prof)) %>% `rownames<-`(Zile)
}

