% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.R
\name{recode_to_pmml}
\alias{recode_to_pmml}
\title{Creates a PMML document from variable and variable details sheets for specified database.}
\usage{
recode_to_pmml(var_details_sheet, vars_sheet, db_name, vars_to_convert = NULL)
}
\arguments{
\item{var_details_sheet}{A data frame representing a variable details sheet.}

\item{vars_sheet}{A data frame representing a variables sheet.}

\item{db_name}{A string containing the name of the database that holds
the start variables. Should match up with one of the databases in the
databaseStart column.}

\item{vars_to_convert}{A vector of strings containing the names of variables
from the variable column in the variable details sheet that should be
converted to PMML. Passing in an empty vector will convert all the variables.}
}
\value{
A PMML document.
}
\description{
Creates a PMML document from variable and variable details sheets for specified database.
}
\examples{
var_details_sheet <-
data.frame(
 "variable" = rep(c("A", "B", "C"), each = 3),
 "dummyVariable" = c("AY", "AN", "ANA", "BY", "BN", "BNA", "CY", "CN", "CNA"),
 "toType" = rep("cat", times = 9),
 "databaseStart" = rep("tester", times = 9),
 "variableStart" = rep(
   c("tester::startA", "tester::startB", "tester::startC"),
   each = 3
 ),
 "fromType" = rep("cat", times = 9),
 "recTo" = rep(c("1", "2", "NA::a"), times = 3),
 "numValidCat" = rep("2", times = 9),
 "catLabel" = rep(c("Yes", "No", "Not answered"), times = 3),
 "catLabelLong" = rep(c("Yes", "No", "Not answered"), times =
                        3),
 "recFrom" = rep(c("1", "2", "9"), times = 3),
 "catStartLabel" = rep(c("Yes", "No", "Not answered"), times =
                         3),
 "variableStartShortLabel" = rep(c("Group A", "Group B", "Group C"), each =
                                   3),
 "variableStartLabel" = rep(c("Group A", "Group B", "Group C"), each =
                              3),
 "units" = rep("NA", times = 9),
 "notes" = rep("This is not real data", times = 9)
)
vars_sheet <-
 data.frame(
   "variable" = c("A", "B", "C"),
   "label" = c("Group A", "Group B", "Group C"),
   "labelLong" = c("Group A", "Group B", "Group C"),
   "section" = rep("tester", times=3),
   "subject" = rep("tester",times = 3),
   "variableType" = rep("Categorical", times=3),
   "databaseStart" = rep("tester", times = 3),
   "units" = rep("NA", times = 3),
   "variableStart" = c("tester::startA", "tester::startB", "tester::startC")
 )
db_name <- "tester"
vars <- c("A", "B", "C")

actual_pmml <- recode_to_pmml(
var_details_sheet,
vars_sheet,
db_name,
vars
)

}
