% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_geo_code.R
\name{validate_geo_code}
\alias{validate_geo_code}
\title{Validate Conformity with NUTS Geo Codes (vector)}
\usage{
validate_geo_code(geo, nuts_year = 2016)
}
\arguments{
\item{geo}{A vector of geographical code to validate.}

\item{nuts_year}{A valid NUTS edition year.}
}
\value{
A character list with the valid typology, or 'invalid' in the cases
when the geo coding is not valid.
}
\description{
Validate that \code{geo} is conforming with the \code{NUTS1},
\code{NUTS2}, or \code{NUTS3} typologies.
While country codes are technically not part of the NUTS typologies,
Eurostat de facto uses a \code{NUTS0} typology to identify countries.
This de facto typology has three exception which are handled by the
\link[regions]{validate_nuts_countries} function.
}
\details{
NUTS typologies have different versions, therefore the conformity
is validated with one specific versions, which can be any of these:
\code{1999}, \code{2003}, \code{2006}, \code{2010},
\code{2013}, the currently used \code{2016} and the already
announced and defined \code{2021}.

The NUTS typology was codified with the \code{NUTS2003}, and the
pre-1999 NUTS typologies may confuse programmatic data processing,
given that some  NUTS1 regions were identified with country codes
in smaller countries that had no \code{NUTS1} divisions.

Currently the \code{2016} is used by Eurostat, but many datasets
still contain \code{2013} and sometimes earlier metadata.
}
\examples{
\donttest{
my_reg_data <- data.frame (
  geo = c("BE1", "HU102", "FR1",
          "DED", "FR7", "TR", "DED2",
          "EL", "XK", "GB"),
  values = runif(10))

validate_geo_code(my_reg_data$geo)
}
}
