% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Claims-class.R
\name{apply_treaty}
\alias{apply_treaty}
\title{Claims: apply a treaty}
\usage{
apply_treaty(claims, treaty)
}
\arguments{
\item{claims}{\code{Claims} (\code{\link{Claims-class}}) object}

\item{treaty}{\code{Treaty} (\code{\link{QS-class}} or \code{\link{XL-class}} or \code{\link{SL-class}}) object}
}
\value{
The updated \code{Claims} object
}
\description{
\code{apply_treaty} applies a treaty on an object of type \code{Claims} (\code{\link{Claims-class}}).
}
\examples{
c <- data.frame(year = unlist(sapply(2000:2017, function(x) rep(x, rpois(1,3)))))
c$amount <- pmax(rnorm(nrow(c), 200000, 100000), 0)
p <- aggregate(amount ~ year, c, sum)
claims <- claims(c, p)
treaty_1 <- xl(ded = 100000, lim = 20000, aad = 5000,
               aal = 200000, prm = 0.01, rns = 1)
claims <- apply_treaty(claims, treaty_1)

}
