% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{batteries}
\alias{batteries}
\title{Batteries}
\format{
An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 995 rows and 12 columns.
}
\source{
\url{https://github.com/openrepair/data/tree/master/quests/batteries}
}
\usage{
batteries
}
\description{
Categorizing repair attempts on battery-powered devices recorded at community events.
}
\details{
Dataset of battery-powered device repair records from the Open Repair Alliance in ORDS format style with added \code{step_barrier} values.
Results of \href{https://openrepair.org/open-data/insights/batteries/}{Open Repair Data quest BattCat}.
\describe{
\item{id_ords}{ID. Unique identifier from the partner organisation.}
\item{data_provider}{Data provider. Option from ORDS codelist. Name of partner organisation.}
\item{country}{Country. Three letter
\href{https://github.com/openrepair/data/blob/master/tools/iso_country_codes/iso_country_codes.csv}{ISO code},
e.g. “GBR”.}
\item{step_barrier_id}{Fault type ID.}
\item{step_barrier}{Fault type. Name of the step or barrier.
Option from \href{https://github.com/openrepair/data/blob/master/quests/batteries/battcat_step_barrier.csv}{battery codelist}.}
\item{product_category}{Product category. Option from ORDS
\href{https://standard.openrepair.org/standard.html#ords-product-category-values}{product category codelist}}
\item{brand}{Brand.}
\item{repair_status}{Repair status option from the battery codelist.}
\item{year_of_manufacture}{Year of manufacture.}
\item{event_date}{Event date. The date of the repair event that the repair took place at.}
\item{language}{Language of problem description. 2 char ISO language code.}
\item{problem}{Problem description.}
}
}
\keyword{datasets}
