% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_sumstats.R
\name{ru_sumstats}
\alias{ru_sumstats}
\title{Calculate Descriptive Statistics}
\usage{
ru_sumstats(
  dsetin,
  analysisvars = NULL,
  analysisvarlabels = "",
  groupbyvars = NULL,
  statslist = c("n", "mean", "median", "min", "max", "sd", "q1", "q3"),
  statsinrowsyn = "N",
  analysisvardps = 0,
  statsdps = list(mean = 1, median = 1, sd = 2, se = 2),
  codedecodevarpairs = c(""),
  varcodelistpairs = c(""),
  codelistnames = list(),
  totalforvar = NULL,
  totalid = NULL,
  totaldecode = c("Total")
)
}
\arguments{
\item{dsetin}{The data set that will be ounted to generate descriptive statistics.}

\item{analysisvars}{The variables to be analysed.}

\item{analysisvarlabels}{Specify a label statement which will be used to defined labels for statistics analysis variables defined in parameter ANALYSISVARS.}

\item{groupbyvars}{Specifies the variables whose values define the subgroup combinations for the analysis. The variables can be divided by statements inside
of ( and ) to represent different levels of subgroup.}

\item{statslist}{Specifies a list of summary statistics to be produced.}

\item{statsinrowsyn}{Place resulting descriptive statistics in rows or columns.}

\item{analysisvardps}{Base precision of descriptive statistics prior to incorporating STATSDPS details.}

\item{statsdps}{List of additional statistic-specific precision values to add to ANALYSISVARDPS.}

\item{codedecodevarpairs}{Specifies code and decode variable pairs. Those variables should be in parameter GROUPBYVARSNUMER.
One variable in the pair will contain the code, which is used in counting and ordering, and the other
will contain decode, which is used for presentation.}

\item{varcodelistpairs}{List of code/decode pairs of variables.}

\item{codelistnames}{List of decodes for use with decoding code/decode pairs.}

\item{totalforvar}{Variable for which overall totals are required within all other grouped class variables.}

\item{totalid}{Value(s) used to populate the variable(s) specified in totalforvar.}

\item{totaldecode}{Value(s) used to populate the variable(s) of the decode variable(s) of the totalforvar.}
}
\value{
A data frame based on the incoming data frame but collapsed by groups with descriptive statistics added.
}
\description{
Pass in a data frame along with identification options and have descriptive statistics derived.
}
\examples{
library(repfun)
library(dplyr)
datdir <- file.path(gsub("\\\\","/",tempdir(),fixed=TRUE),"datdir");
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
rfenv <- repfun::rs_setup(D_POPDATA=repfun::adsl \%>\% dplyr::filter(SAFFL =='Y'),
         D_SUBJID=c("STUDYID","USUBJID"),
         R_DICTION=NULL,
         R_OTHERDATA=NULL,
         R_INPUTDATA=NULL,
         R_RAWDATA=NULL,
         R_SDTMDATA=NULL,
         R_ADAMDATA=datdir,
         RetEnv=TRUE)
G_POPDATA <- rfenv$G_POPDATA \%>\% dplyr::mutate(
   TRT01AN=ifelse(TRT01A=='Placebo',1,
           ifelse(TRT01A=='Xanomeline Low Dose',2,3))) \%>\%
           ru_labels(varlabels=list('TRT01AN'='Actual Treatment for Period 01 (n)'))
ru_sumstats(G_POPDATA,
            analysisvars=c("AGE","TRTDURD"),
            groupbyvars=c("STUDYID","TRT01AN"),
            codedecodevarpairs=c("TRT01AN", "TRT01A"),
            totalforvar="TRT01AN", totalid=99,
            totaldecode="Total",
            statsinrowsyn = "Y",
            analysisvardps=list("AGE"=1,"TRTDURD"=2),
            statslist=c("n", "mean", "median", "sd", "min", "max")) \%>\% head(10)

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
