% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.R
\name{Copy}
\alias{Copy}
\alias{Copy,ANY-method}
\alias{Copy,data.table-method}
\alias{Copy,list-method}
\alias{Copy,refClass-method}
\alias{Copy,data.frame-method}
\title{Recursive copying of nested environments, and other "hard to copy" objects}
\usage{
Copy(object, ...)

\S4method{Copy}{ANY}(
  object,
  filebackedDir,
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL),
  verbose = getOption("reproducible.verbose"),
  ...
)

\S4method{Copy}{data.table}(object, ...)

\S4method{Copy}{list}(object, ...)

\S4method{Copy}{refClass}(object, ...)

\S4method{Copy}{data.frame}(object, ...)
}
\arguments{
\item{object}{An R object (likely containing environments) or an environment.}

\item{...}{Only used for custom Methods}

\item{filebackedDir}{A directory to copy any files that are backing R objects,
currently only valid for \code{Raster} classes. Defaults
to \code{.reproducibleTempPath()}, which is unlikely to be very useful.
Can be \code{NULL}, which means that the file will not be
copied and could therefore cause a collision as the
pre-copied object and post-copied object would have the same
file backing them.}

\item{drv}{If using a database backend, \code{drv} must be an object that
inherits from \code{DBIDriver} (e.g., \code{RSQLite::SQLite}).}

\item{conn}{an optional \code{DBIConnection} object, as returned by \code{dbConnect()}.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}
}
\value{
The same object as \code{object}, but with pass-by-reference class elements "deep" copied.
\code{reproducible} has methods for several classes.
}
\description{
When copying environments and all the objects contained within them, there are
no copies made: it is a pass-by-reference operation. Sometimes, a deep copy is
needed, and sometimes, this must be recursive (i.e., environments inside
environments).
}
\details{
To create a new Copy method for a class that needs its own method, try something like
shown in example and put it in your package (or other R structure).
}
\examples{
e <- new.env()
e$abc <- letters
e$one <- 1L
e$lst <- list(W = 1:10, X = runif(10), Y = rnorm(10), Z = LETTERS[1:10])
ls(e)

# 'normal' copy
f <- e
ls(f)
f$one
f$one <- 2L
f$one
e$one ## uh oh, e has changed!

# deep copy
e$one <- 1L
g <- Copy(e)
ls(g)
g$one
g$one <- 3L
g$one
f$one
e$one
## To create a new deep copy method, use the following template
## setMethod("Copy", signature = "the class", # where = specify here if not in a package,
##           definition = function(object, filebackendDir, ...) {
##           # write deep copy code here
##           })

}
\seealso{
\code{\link[=.robustDigest]{.robustDigest()}}, \code{\link[=Filenames]{Filenames()}}
}
\author{
Eliot McIntire
}
