% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_negbinomial.R
\name{dist_negbinomial}
\alias{dist_negbinomial}
\title{Negative binomial Distribution}
\usage{
dist_negbinomial(size = NULL, mu = NULL)
}
\arguments{
\item{size}{Number of successful trials parameter, or \code{NULL} as a
placeholder. Non-integer values > 0 are allowed.}

\item{mu}{Mean parameter, or \code{NULL} as a placeholder.}
}
\value{
A \code{NegativeBinomialDistribution} object.
}
\description{
See \link[stats:NegBinomial]{stats::NegBinomial}
}
\details{
Both parameters can be overridden with
\code{with_params = list(size = ..., prob = ...)}.
}
\examples{
d_nbinom <- dist_negbinomial(size = 3.5, mu = 8.75)
x <- d_nbinom$sample(100)
d_emp <- dist_empirical(x)

plot_distributions(
  empirical = d_emp,
  theoretical = d_nbinom,
  estimated = d_nbinom,
  with_params = list(
    estimated = inflate_params(
      fitdistrplus::fitdist(x, distr = "nbinom")$estimate
    )
  ),
  .x = 0:max(x)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
