% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resizableSplitLayout.R
\name{resizableSplitUI}
\alias{resizableSplitUI}
\title{resizableSplitUI}
\usage{
resizableSplitUI(
  id,
  sidebarpane,
  maincontenttop,
  maincontentbottom,
  sidebar.percentage = 15,
  maincontenttop.percentage = 85,
  return.only.taglist = FALSE
)
}
\arguments{
\item{id}{Module identifier}

\item{sidebarpane}{Content for page sidebar}

\item{maincontenttop}{Content for page main top pane}

\item{maincontentbottom}{Content for page main bottom pane}

\item{sidebar.percentage}{Width for sidebar as percentage}

\item{maincontenttop.percentage}{Height for page main top pane as percentage}

\item{return.only.taglist}{logical to return taglist instead of a bootstrapPage}
}
\value{
A Shiny UI object. If \code{return.only.taglist = TRUE}, returns a
\code{shiny.tag.list} object containing the resizable split layout elements.
If \code{return.only.taglist = FALSE} (default), returns a Shiny bootstrap
page (from \code{shiny::bootstrapPage}) containing the resizable layout.
}
\description{
resizableSplitUI
}
\examples{
if (interactive()) {

  ui <- resizableSplitUI("splitModule",
    sidebarpane = shiny::div("This is the sidebar"),
    maincontenttop = shiny::div("This is the maincontenttop"),
    maincontentbottom = shiny::div("This is the maincontentbottom")
  )

  server <- function(input, output, session) { }

  shinyApp(ui, server)
}

}
