% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terra_utils.R
\name{invert_vector}
\alias{invert_vector}
\title{Invert a vector layer according to the extent of a restopt problem.}
\usage{
invert_vector(vector_layer, extent = NULL, filter = NULL)
}
\arguments{
\item{vector_layer}{\code{\link[terra:vect]{terra::vect()}} Vector layer.}

\item{extent}{\code{\link[terra:SpatExtent-class]{terra::SpatExtent}} Optional: you can specify another extent as the
input vector layer extent for the inversion.}

\item{filter}{Optional: filter to apply to \code{x}. Leave NULL for no filtering.}
}
\value{
A \code{\link[terra:vect]{terra::vect()}} Vector object.
}
\description{
Invert a vector layer according to the extent of a restopt problem.
}
\details{
Invert a vector layer according to its extent, or a user-specified extent.
This function is useful to derive locked out areas from accessible areas,
e.g. buffer around tracks.
}
\examples{
\dontrun{
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)
available <- vect(
  system.file("extdata", "accessible_areas.gpkg", package = "restoptr")
)
locked_out <- invert_vector(
  vector_layer = available,
  extent = ext(habitat_data),
  filter = available$ID==2
)
}

}
