% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{mask}
\alias{mask}
\title{Mask Text for Blind Review}
\usage{
mask(
  x,
  mask_message = "masked for blind review",
  hide = rmarkdown::metadata$mask
)
}
\arguments{
\item{x}{Atomic character vector to be masked.}

\item{mask_message}{Atomic character vector to mask \code{x} with when
\code{mask: yes}, Default: 'masked for blind review'}

\item{hide}{Logical, Default: rmarkdown::metadata$mask}
}
\value{
Character vector.
}
\description{
The YAML front matter tag \code{mask} determines whether
the text is displayed or replaced by \code{mask_message}.
The YAML tag can take the values \code{yes} or \code{no}.
}
\examples{
mask("this is masked", hide = TRUE)
}
\seealso{
\code{\link[rmarkdown]{metadata}}
}
