% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support.R
\name{set_pending_answers}
\alias{set_pending_answers}
\title{Set pending answers}
\usage{
set_pending_answers(df)
}
\arguments{
\item{df}{A data frame of exercises.}
}
\value{
A data frame.
}
\description{
The answers we want to process are indicated by the character "?". Fill in the
specified answers by generating combinations of the available options to fill
the gaps in order, from value 1 to the maximum number of options available: the
first option for each of the gaps, the second for each of the gaps, and so on.
}
\examples{

file <- system.file("extdata/example.csv", package = "rexer")
df <- read_exercise_csv(file)
df <- set_pending_answers(df)

}
\seealso{
Other support functions: 
\code{\link{create_exercise_csv}()},
\code{\link{create_exercise_data_frame}()},
\code{\link{create_exercise_excel}()},
\code{\link{read_exercise_csv}()},
\code{\link{read_exercise_excel}()},
\code{\link{vector_to_string}()},
\code{\link{write_exercise_csv}()}
}
\concept{support functions}
