#' Dataset of Ictaluridae Taxon from Years 2017 to 2019
#'
#' A dataset as a result of a search query of taxon 'Ictaluridae' and date range
#' '2017-2019' on fishnet2.net
#'
#' @format A data frame with 273 rows and 16 variables: \describe{
#'   \item{InstitutionCode}{unique code given to institution who owns the data}
#'   \item{IndividualCount}{Number of fish individuals}
#'   \item{ScientificName}{Scientific name of fish observation}
#'   \item{Family}{Family of fish observation}
#'   \item{PreparationType}{Type of preparation}
#'   \item{Tissues}{Whether observation contains tissues}
#'   \item{Latitude}{Latitude observed}
#'   \item{Longitude}{Longitude observed}
#'   \item{Country}{Country that lot was observed in}
#'   \item{StateProvince}{State or province where lot was observed}
#'   \item{County}{County that lot was observed in}
#'   \item{YearCollected}{Year collected}
#'   \item{MonthCollected}{Month collected}
#'   \item{DayCollected}{Day collected}
#'   \item{BasisOfRecord}{Preserved Specimen}
#'   \item{DateLastModified}{Data record last modified in database}
#'
#' }
#' @source \url{http://www.fishnet2.net/search.aspx?t=ictaluridae&d=2017-2019}
"ictaluridae"

#' Dataset of Records from Louisiana from Years 2005 to 2006
#'
#' A dataset as a result of a search query of location 'Louisiana' and date range
#' '2005-2006' on fishnet2.net
#'
#' @format A data frame with 273 rows and 20 variables: \describe{
#'   \item{InstitutionCode}{unique code given to institution who owns the data}
#'   \item{CollectionCode}{Collection Code}
#'   \item{IndividualCount}{Number of fish individuals}
#'   \item{ScientificName}{Scientific name of fish observation}
#'   \item{Family}{Family of fish observation}
#'   \item{PreparationType}{Type of preparation}
#'   \item{Tissues}{Whether observation contains tissues}
#'   \item{Latitude}{Latitude observed}
#'   \item{Longitude}{Longitude observed}
#'   \item{HorizontalDatum}{Horizontal Datum}
#'   \item{Country}{Country that lot was observed in}
#'   \item{StateProvince}{State or province where lot was observed}
#'   \item{County}{County that lot was observed in}
#'   \item{YearCollected}{Year collected}
#'   \item{MonthCollected}{Month collected}
#'   \item{DayCollected}{Day collected}
#'   \item{Collector}{Name of collector}
#'   \item{GeorefMethod}{Geo Reference Method}
#'   \item{BasisOfRecord}{Preserved Specimen}
#'   \item{DateLastModified}{Data record last modified in database}
#'
#' }
#' @source \url{http://www.fishnet2.net/search.aspx?l=+Louisiana&d=2005-2006}
"louisiana"
