% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhoK.R
\name{rhoK}
\alias{rhoK}
\title{Rho (kappa)}
\usage{
rhoK(
  x,
  OcSBaserate,
  testSetLength,
  testSetBaserateInflation = 0,
  OcSLength = 10000,
  replicates = 800,
  ScSKappaThreshold = 0.9,
  ScSKappaMin = 0.4,
  ScSPrecisionMin = 0.6,
  ScSPrecisionMax = 1,
  method = "standard"
)
}
\arguments{
\item{x}{The observed kappa value, \code{\link[=getTestSet]{testSet}} or \code{\link{contingencyTable}} that will be tested with rho}

\item{OcSBaserate}{The \code{\link{baserate}} of the observed \code{\link{codeSet}} (defaults to \code{\link{baserate}} of \code{\link[=getTestSet]{testSet}} or \code{\link{contingencyTable}})}

\item{testSetLength}{The length of the \code{\link[=getTestSet]{testSet}} (ignored unless \emph{data} is an observed kappa value)}

\item{testSetBaserateInflation}{The minimum \code{\link{baserate}} from the sampling procedure}

\item{OcSLength}{The length of the observed \code{\link{codeSet}}}

\item{replicates}{The number of simulated \code{\link[=getTestSet]{codeSets}} to use in the null hypothesis distribution for rho; similar to replicates in a Monte Carlo study}

\item{ScSKappaThreshold}{The maximum kappa value used to generate simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}

\item{ScSKappaMin}{The minimum kappa value used to generate simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}

\item{ScSPrecisionMin}{The minimum precision to be used for generation of simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}

\item{ScSPrecisionMax}{The maximum precision to be used for generation of simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho,}

\item{method}{set to "c" to calculate using the C++ implmentation. Defaults to "standard"}
}
\value{
rho for the given parameters

rho for the given parameters
}
\description{
This function calculates rho for an observed kappa value with associated set parameters
(testSetLength and OcSBaserate). Called by \code{\link{rho}}. A p-value is returned and if 
this value is less than 0.05, it is said that the handset does generalize to the entire set
}
\seealso{
\code{\link{rho}}
}
