% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.R
\name{relevels}
\alias{relevels}
\title{Relevel a factor by a named or unnamed vector.}
\usage{
relevels(
  x,
  refs,
  missingLevels = c("pass", "warning", "error"),
  unrecognisedLevels = c("warning", "pass", "error")
)
}
\arguments{
\item{x}{A factor or a character string vector that will be cast into factor}

\item{refs}{A named vector or unnamed vector.}

\item{missingLevels}{Actions taken in case existing levels are missing:
'pass', 'warning', or 'error'.}

\item{unrecognisedLevels}{Actions taken in case unrecognised levels are
found: 'pass', 'warning', or 'error'.}
}
\value{
A vector of factor
}
\description{
This function wraps \code{\link{relevelsByNamedVec}} for named vector and
\code{\link{relevelsByNotNamedVec}} for not named vectors
}
\examples{

oldFactor <- factor(c("A", "B", "A", "C", "B"), levels=LETTERS[1:3])
refLevels <- c("B", "C", "A")
refDict <- c("A"="a", "B"="b", "C"="c")
newFactor <- relevels(oldFactor, refLevels)
stopifnot(identical(newFactor, factor(c("A", "B", "A", "C", "B"), levels=c("B", "C", "A"))))
newFactor2 <-  relevels(oldFactor, refDict)
stopifnot(identical(newFactor2, factor(c("a", "b", "a", "c", "b"), levels=c("a", "b", "c"))))

}
\seealso{
\code{\link{relevelsByNamedVec}} and
\code{\link{relevelsByNotNamedVec}}
}
