% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{blackholes}
\alias{blackholes}
\alias{sagAstar}
\alias{powehi}
\title{Images of black holes: Sagettarius A* and Pōwehi}
\format{
A 240x240 and 250x250 matrix containing cells evaluated between 0 and 1.
}
\source{
\url{https://commons.wikimedia.org/wiki/File:Black_hole_-_Messier_87_crop_max_res.jpg}
\url{https://commons.wikimedia.org/wiki/File:EHT_Saggitarius_A_black_hole.tif}
\url{https://mtsch.github.io/Ripserer.jl/v0.10/generated/sublevelset/}

\strong{Image Processing Details}

For both images we used the same proccess as follows.
First, we obtained our images from \href{https://commons.wikimedia.org/wiki/File:EHT_Saggitarius_A_black_hole.tif}{Wikimedia Commons: Sagittarius A*}
\href{https://commons.wikimedia.org/wiki/File:Black_hole_-_Messier_87_crop_max_res.jpg}{Wikimedia Commons: Pōwehi}.
We then utilize \pkg{magick} to
convert the images from RGB to grayscale using the default
"perceptually-weighted" conversion. Next we acquired the raw 3D arrays,
converted the data type to numerical, and dropped the singleton channel
dimension. We then transposed the matrices and vertically flipped it to align
with how \pkg{graphics} reads matrices.
}
\description{
These data sets contain grayscale bitmaps of black holes
Sagettarius A* and Pōwehi (the unoffical name of Messier 87's black hole).
\code{sagAstar} contains a 240x240 matrix with a spatial scale of approximately 1.3 millon
km per cell (calculated by dividing the length of the shadow by the number of
cells it covers in the image: 50 million km / 38).
\code{powehi} contains a 250x250 matrix of Pōwehi with a spatial scale of
approximately 800 million km per cell (calculated the same way as above:
40 billion km / 50).
}
\examples{
image(powehi, 
  col = hcl.colors(256, palette = "inferno", alpha = NULL, rev = FALSE, 
  fixup = TRUE), axes = FALSE, asp = 1)
title(main = "Messier 87's Black Hole: Powehi")

# based on the image, we expect one especially prominent 
# persistent feature in 1D
ph <- cubical(powehi)

plot.new()
plot.window(
  xlim = c(0, max(ph$death)),
  ylim = c(0, max(ph$death)),
  asp = 1
)
axis(1L)
axis(2L)
abline(a = 0, b = 1)
points(ph[ph$dim == 1L, c("birth", "death")], pch = 17L, col = "orange")
}
