/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.DemetraException;
import jdplus.toolkit.base.api.processing.DiagnosticsConfiguration;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ResidualTradingDaysDiagnosticsConfiguration
implements DiagnosticsConfiguration {
    private static final AtomicReference<ResidualTradingDaysDiagnosticsConfiguration> DEFAULT = new AtomicReference<ResidualTradingDaysDiagnosticsConfiguration>(ResidualTradingDaysDiagnosticsConfiguration.builder().build());
    public static final boolean ACTIVE = true;
    public static final boolean MONTHLY = true;
    private final boolean active;
    public static final double SEV = 0.001;
    public static final double BAD = 0.01;
    public static final double UNC = 0.05;
    private final boolean monthlyOnly;
    private final double severeThreshold;
    private final double badThreshold;
    private final double uncertainThreshold;

    public static void setDefault(ResidualTradingDaysDiagnosticsConfiguration config) {
        DEFAULT.set(config);
    }

    public static ResidualTradingDaysDiagnosticsConfiguration getDefault() {
        return DEFAULT.get();
    }

    public static Builder builder() {
        return new Builder().monthlyOnly(true).active(true).severeThreshold(0.001).badThreshold(0.01).uncertainThreshold(0.05);
    }

    public void check() {
        if (this.severeThreshold > this.badThreshold || this.badThreshold > this.uncertainThreshold || this.uncertainThreshold > 1.0 || this.severeThreshold <= 0.0) {
            throw new DemetraException("Invalid settings in thresholds");
        }
    }

    public DiagnosticsConfiguration activate(boolean active) {
        if (this.active == active) {
            return this;
        }
        return this.toBuilder().active(active).build();
    }

    @Generated
    ResidualTradingDaysDiagnosticsConfiguration(boolean active, boolean monthlyOnly, double severeThreshold, double badThreshold, double uncertainThreshold) {
        this.active = active;
        this.monthlyOnly = monthlyOnly;
        this.severeThreshold = severeThreshold;
        this.badThreshold = badThreshold;
        this.uncertainThreshold = uncertainThreshold;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().active(this.active).monthlyOnly(this.monthlyOnly).severeThreshold(this.severeThreshold).badThreshold(this.badThreshold).uncertainThreshold(this.uncertainThreshold);
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public boolean isMonthlyOnly() {
        return this.monthlyOnly;
    }

    @Generated
    public double getSevereThreshold() {
        return this.severeThreshold;
    }

    @Generated
    public double getBadThreshold() {
        return this.badThreshold;
    }

    @Generated
    public double getUncertainThreshold() {
        return this.uncertainThreshold;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResidualTradingDaysDiagnosticsConfiguration)) {
            return false;
        }
        ResidualTradingDaysDiagnosticsConfiguration other = (ResidualTradingDaysDiagnosticsConfiguration)o;
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.isMonthlyOnly() != other.isMonthlyOnly()) {
            return false;
        }
        if (Double.compare(this.getSevereThreshold(), other.getSevereThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getBadThreshold(), other.getBadThreshold()) != 0) {
            return false;
        }
        return Double.compare(this.getUncertainThreshold(), other.getUncertainThreshold()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + (this.isMonthlyOnly() ? 79 : 97);
        long $severeThreshold = Double.doubleToLongBits(this.getSevereThreshold());
        result = result * 59 + (int)($severeThreshold >>> 32 ^ $severeThreshold);
        long $badThreshold = Double.doubleToLongBits(this.getBadThreshold());
        result = result * 59 + (int)($badThreshold >>> 32 ^ $badThreshold);
        long $uncertainThreshold = Double.doubleToLongBits(this.getUncertainThreshold());
        result = result * 59 + (int)($uncertainThreshold >>> 32 ^ $uncertainThreshold);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "ResidualTradingDaysDiagnosticsConfiguration(active=" + this.isActive() + ", monthlyOnly=" + this.isMonthlyOnly() + ", severeThreshold=" + this.getSevereThreshold() + ", badThreshold=" + this.getBadThreshold() + ", uncertainThreshold=" + this.getUncertainThreshold() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean active;
        @Generated
        private boolean monthlyOnly;
        @Generated
        private double severeThreshold;
        @Generated
        private double badThreshold;
        @Generated
        private double uncertainThreshold;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public @NonNull Builder monthlyOnly(boolean monthlyOnly) {
            this.monthlyOnly = monthlyOnly;
            return this;
        }

        @Generated
        public @NonNull Builder severeThreshold(double severeThreshold) {
            this.severeThreshold = severeThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder badThreshold(double badThreshold) {
            this.badThreshold = badThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder uncertainThreshold(double uncertainThreshold) {
            this.uncertainThreshold = uncertainThreshold;
            return this;
        }

        @Generated
        public @NonNull ResidualTradingDaysDiagnosticsConfiguration build() {
            return new ResidualTradingDaysDiagnosticsConfiguration(this.active, this.monthlyOnly, this.severeThreshold, this.badThreshold, this.uncertainThreshold);
        }

        @Generated
        public @NonNull String toString() {
            return "ResidualTradingDaysDiagnosticsConfiguration.Builder(active=" + this.active + ", monthlyOnly=" + this.monthlyOnly + ", severeThreshold=" + this.severeThreshold + ", badThreshold=" + this.badThreshold + ", uncertainThreshold=" + this.uncertainThreshold + ")";
        }
    }
}

