/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class CyclicalComponent {
    public static int dim() {
        return 2;
    }

    public static StateComponent stateComponent(double dumpingFactor, double period, double cvar) {
        Data data = new Data(dumpingFactor, period, cvar);
        return new StateComponent(new Initialization(data), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    @Generated
    private CyclicalComponent() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Data {
        private final double var;
        private final double cdump;
        private final double cperiod;

        public Data(double cyclicaldumpingfactor, double cyclicalperiod, double var) {
            this.var = var;
            this.cperiod = cyclicalperiod;
            this.cdump = cyclicaldumpingfactor;
        }
    }

    static class Initialization
    implements ISsfInitialization {
        final Data data;

        Initialization(Data data) {
            this.data = data;
        }

        @Override
        public boolean isDiffuse() {
            return false;
        }

        @Override
        public int getDiffuseDim() {
            return 0;
        }

        @Override
        public int getStateDim() {
            return 2;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix p) {
            double q = this.data.var / (1.0 - this.data.cdump * this.data.cdump);
            p.diagonal().set(q);
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        final Data data;
        private final double ccos;
        private final double csin;
        private final double e;

        Dynamics(Data data) {
            this.data = data;
            this.e = Math.sqrt(data.var);
            double q = Math.PI * 2 / data.cperiod;
            this.ccos = data.cdump * Math.cos(q);
            this.csin = data.cdump * Math.sin(q);
        }

        @Override
        public int getInnovationsDim() {
            return this.data.var == 0.0 ? 0 : 2;
        }

        @Override
        public void V(int pos, FastMatrix v) {
            v.diagonal().set(this.data.var);
        }

        @Override
        public void S(int pos, FastMatrix s) {
            s.diagonal().set(this.e);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.data.var != 0.0;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.set(0, 0, this.ccos);
            tr.set(0, 1, this.csin);
            tr.set(1, 0, -this.csin);
            tr.set(1, 1, this.ccos);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            double a = x.get(0);
            double b = x.get(1);
            x.set(0, a * this.ccos + b * this.csin);
            x.set(1, -a * this.csin + b * this.ccos);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.addAY(this.e, u);
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.diagonal().add(this.data.var);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            double a = x.get(0);
            double b = x.get(1);
            x.set(0, a * this.ccos - b * this.csin);
            x.set(1, a * this.csin + b * this.ccos);
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.setAY(this.e, x);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }
}

