% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differencing.R
\name{rangemean_tstat}
\alias{rangemean_tstat}
\title{Range-Mean Regression}
\usage{
rangemean_tstat(data, period = 0, groupsize = 0, trim = 0)
}
\arguments{
\item{data}{data to test.}

\item{period}{periodicity of the data.}

\item{groupsize}{number of observations per group (before being trimmed).
The default group size (\code{groupsize = 0}) is computed as followed:
\itemize{
\item if \code{period = 12} or \code{period = 6}, it is equal to \code{12};
\item if \code{period = 4} it is equal to \code{12} if the data has at least 166 observations,
\code{8} otherwise;
\item if \code{period = 3} or \code{period = 2} it is equal to \code{12} if the data has at least 166 observations,
\code{6} otherwise;
\item if \code{period = 1} it is equal to \code{9} if the data has at least 166 observations,
\code{5} otherwise;
\item it is equal to \code{period} otherwise.
}}

\item{trim}{number of trimmed observations.}
}
\value{
T-Stat of the slope of the range-mean regression.
}
\description{
Function to perform a range-mean regression, trimmed to avoid outlier distortion.
The can be used to select whether the original series will be transformed into log or maintain in level.
}
\details{
First, the data is divided into \eqn{n} groups of successive observations of length \eqn{l} (\code{groupsize}).
That is, the first group is formed with the first \eqn{l} observations,
the second group is formed with observations \eqn{1+l} to \eqn{2l}, etc.
Then, for each group \eqn{i}, the observations are sorted and the \code{trim} smallest and largest
observations are rejected (to avoid outlier distortion).
With the other observations, the range (noted \eqn{y_i}) and mean (noted \eqn{m_i}) are computed.

Finally, the following regression is performed :
\deqn{
y_t = \alpha + \beta m_t + u_t.
}
The function \code{rangemean_tstat} returns the T-statistic associated to \eqn{\beta}.
If it is significantly higher than 0, log transformation is recommended.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
y <- ABS$X0.2.09.10.M
# Multiplicative pattern
plot(y)
period <- 12
rm_t <- rangemean_tstat(y, period = period, groupsize = period)
rm_t # higher than 0
# Can be tested:
pt(rm_t, period - 2, lower.tail = FALSE)
# Or :
1 - cdf_t(period - 2, rm_t)

# Close to 0
rm_t_log <- rangemean_tstat(log(y), period = period, groupsize = period)
rm_t_log
pt(rm_t_log, period - 2, lower.tail = FALSE)
\dontshow{\}) # examplesIf}
}
