% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendars.R
\name{special_day}
\alias{special_day}
\title{List of Pre-Defined Holidays to choose from}
\usage{
special_day(event, offset = 0, weight = 1, validity = NULL)
}
\arguments{
\item{event}{the event to add (see details).}

\item{offset}{The position of the holiday in relation to the selected
pre-specified holiday measured in days (can be positive or negative).
By default \code{offset = 0}.}

\item{weight}{weight associated to the holiday.}

\item{validity}{validity period: either \code{NULL} (full sample) or a named list
with \code{"start"} and/or "end" dates in the format \code{"YYYY-MM-DD"}.}
}
\value{
returns an object of class \code{c("JD3_SPECIALDAY","JD3_HOLIDAY")} (with name of the event, date, offset...)
}
\description{
Allows to define a holiday choosing from a list of pre-specified events,
equivalent to use \code{fixed_day} or \code{easter_day} functions.
}
\details{
Possible values :

\tabular{ll}{
NEWYEAR        \tab Fixed holiday, falls on January, 1st.                                                  \cr
SHROVEMONDAY   \tab Moving holiday, falls on the Monday before Ash Wednesday (48 days before Easter Sunday). \cr
SHROVETUESDAY  \tab Moving holiday, falls on the Tuesday before Ash Wednesday (47 days before Easter Sunday).\cr
ASHWEDNESDAY   \tab Moving holiday, occurring 46 days before Easter Sunday.                              \cr
MAUNDYTHURSDAY \tab Moving holiday, falls on the Thursday before Easter.                                 \cr
GOODFRIDAY     \tab Moving holiday, falls on the Friday before Easter.                                   \cr
EASTER         \tab Moving holiday, falls between March 22nd and April 25th.                              \cr
EASTERMONDAY   \tab Moving holiday, falls on the day after Easter.                                       \cr
ASCENSION      \tab Moving holiday, celebrated on a Thursday, 39 days after Easter.                        \cr
PENTECOST      \tab Moving holiday, celebrated 49 days after Easter Sunday.                              \cr
WHITMONDAY     \tab Moving holiday, falling on the day after Pentecost.                                  \cr
CORPUSCHRISTI  \tab Moving holiday, celebrated 60 days after Easter Sunday.                              \cr
JULIANEASTER   \tab                                                                                      \cr
MAYDAY         \tab Fixed holiday, falls on May, 1st.                                                      \cr
ASSUMPTION     \tab Fixed holiday, falls on August, 15th.                                                  \cr
HALLOWEEN      \tab Fixed holiday, falls on October, 31st.                                                 \cr
ALLSAINTSDAY    \tab Fixed holiday, falls on November, 1st.                                                 \cr
ARMISTICE      \tab Fixed holiday, falls on November, 11th.                                                \cr
CHRISTMAS      \tab Fixed holiday, falls on December, 25th.
}
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# To add Easter Monday
special_day("EASTERMONDAY")
# To define a holiday for the day after Christmas, with validity and weight
special_day("CHRISTMAS",
    offset = 1, weight = 0.8,
    validity = list(start = "2000-01-01", end = "2020-12-01")
)
\dontshow{\}) # examplesIf}
}
\references{
More information on calendar correction in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/a-calendar-correction}
}
\seealso{
\code{\link{national_calendar}}, \code{\link{fixed_day}}, \code{\link{easter_day}}
}
