% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_estimates.r
\name{Retrieve_stats}
\alias{Retrieve_stats}
\title{Retrieve statistics(bias, variance) of estimators based on a set of paths}
\usage{
Retrieve_stats(paths, true_val, Est, ...)
}
\arguments{
\item{paths}{real-valued matrix representing sample paths of the stochastic process being studied}

\item{true_val}{true value of the estimated parameter}

\item{Est}{estimator (i.e. H_hat)}

\item{...}{parameters to pass to Est}
}
\description{
Retrieve statistics(bias, variance) of estimators based on a set of paths
}
\examples{
m<-45; M<-60; N<-2^10-M
alpha<-1.8; H<-0.8; sigma<-0.3
freq='L';t1=1; t2=2
r=1; k=2; p=0.4

Y<-paths(N_var=10,parallel=TRUE,N=N,m=m,M=M,
         alpha=alpha,H=H,sigma=sigma,freq='L',
         disable_X=FALSE,levy_increments=NULL)

Retrieve_stats(paths=Y,true_val=sigma,Est=sigma_hat,t1=t1,k=2,alpha=alpha,H=H,freq="L")
}
